<?php 
    $server = "websql.in.spsostrov.cz";
    $data = parse_ini_file("../../spso.mysql.ini");
    $username = $data["username"];
    $password = $data["password"];
    $database = $data["database"];

    $pdo = new PDO("mysql:host=$server;dbname=$database;charset=utf8mb4", $username, $password);
    $dotaz = "SELECT * FROM test_zakaznici";

    if(isset($_GET["filtr"])){
        switch($_GET["filtr"]){
            case "abeceda":
                $dotaz = "SELECT * FROM test_zakaznici ORDER BY jmeno";
            break;

            default:
                $dotaz = "SELECT * FROM test_zakaznici ORDER BY id";
            break;
        }
    }
    $result = $pdo->query($dotaz)->fetchAll();

    
?>


<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <title>Test</title>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <h1>Zákazníci</h1>
                <table class="table">
                    <th>Jméno</th>
                    <th>Rok narození</th>
                    <th>Město</th>
                    <th>Počet nákupů</th>
                    <th>Celková ztráta</th>

                    <tbody>
                    <?php
                        foreach ($result as $row) {
                            echo "<tr>";
                                echo "<td>" . htmlspecialchars($row['jmeno']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['rok']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['mesto']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['pocet_nakupu']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['celkova_ztrata']) . "</td>";
                            echo "</tr>";
                        }
                    ?>
                    </tbody>
                </table>
            </div>

            <div class="col-md-3">
                <a href="?filtr=abeceda" class="btn btn-sm btn-primary m-2 d-block">Podle abecedy</a>
            </div>
         </div>
    </div>
</body>
</html>