<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Planety</title>
    <style>
        input::placeholder {
            color: #6c757d !important;
            opacity: 0 !important;
        }
        label {
            color: white !important;
        }
    </style>
    <!-- Latest compiled and minified CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.css"
/>
<!-- Latest compiled JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php
    $server = "websql.in.spsostrov.cz";
$data = parse_ini_file("../spso.mysql.ini");
$username = $data["username"];
$password = $data["password"];
$database = $data["database"];

$pdo = new PDO("mysql:host=$server;dbname=$database;charset=utf8mb4", $username, $password, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

function tableGen($pdo){
    $stmt = $pdo->query("SELECT nazev, polomer, vzdalenost FROM planety");
    $radky = $stmt->fetchAll();
    //echo $radky;
    foreach ($radky as $value){
        echo("<tr><td>". $value["nazev"]."</td><td>".$value["polomer"]."</td><td>".$value["vzdalenost"]."</td></tr>");
    }
}
function cardGen($pdo){
    $stmt = $pdo->query("SELECT id,nazev,url_obrazek,popis_kratky,wikipedia FROM planety");
    $radky = $stmt->fetchAll();
    foreach ($radky as $value){
        echo "<div class=\"col-2 \">
    <div class=\"card text-white bg-black mb-3 mt-3 border h-100\" style=\"margin-top: 15px !important; max-width: 18rem; cursor: pointer;\" onclick=\"location.href='05-planety-detail.php?id=".$value["id"]."'\">
        <img style=\"height: 200px; object-fit: cover;\" src=\"".$value["url_obrazek"]."\">
        <h2>".$value["nazev"]."</h2>
        <p>".$value["popis_kratky"]."</p>
        <a href=\"".$value["wikipedia"]."\">Wikipedia</a>
    </div>
</div>";
    }
}
    ?>
</head>
<body class="bg-dark">
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css"/>
    <div class="container mt-4">
        <table id="planetyTable" class="table table-dark table-striped">
            <thead>
                <tr>
                    <th>Název</th>
                    <th>Poloměr (km)</th>
                    <th>Vzdálenost od Slunce (miliony km)</th>
                </tr>
            </thead>
            <tbody>
                <?php
                tableGen($pdo);
                ?>
            </tbody>
        </table>
    </div>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#planetyTable').DataTable({
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.13.7/i18n/cs.json"
                },
                
                "order": [[0, "asc"]],
                "columnDefs": [
                    { "type": "string", "targets": 0 },
                    { "type": "num", "targets": [1, 2] }
                ],
                "paging": false,
                "searching": true,
                "search": {
                    "placeholder": "Hledat planety..."
                }
            }).search.placeholder = "Hledat planety...";
        });
    </script>
<div class="container w-100 mx-0" style="max-width: 100vw !important;">
    <div class="row flex">
        <?php
        cardGen($pdo);
        
        ?>
        
</div>
</div>
<script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@6.0/dist/fancybox/fancybox.umd.js"></script>
<script>
    //onDocumentReady
    $(document).ready(function() {
        //selector from chrome: #planetyTable_filter > label > input
        let searchBox = $('#planetyTable_filter > label > input');
        searchBox.attr("placeholder", "Hledat planety...");
        
        });
</script>
</body>
</html>