<?php
namespace App\Controllers;

use App\Core\Controller;
use App\Models\Reservation;

class BookingController extends Controller
{

    public function index(): void
    {
        $reservations = Reservation::getAll();

        $this->view->render('booking/index', [
            'reservations' => $reservations,
        ]);
    }


    public function step1(): void
    {
        $this->view->render('booking/step1', [
            'error' => $_GET['error'] ?? null,
        ]);
    }

    public function step1Post(): void
    {
        session_start();

        $date = trim($_POST['date'] ?? '');
        $time = trim($_POST['time'] ?? '');
        $therapist = trim($_POST['therapist'] ?? '');

        if ($date === '' || $time === '' || $therapist === '') {
            $this->redirect('?controller=booking&action=step1&error=Vyplň datum i čas a masérku.');
        }

        $_SESSION['datetime'] = $date . ' ' . $time;
        $_SESSION['booking_therapist'] = $therapist;

        $this->redirect('?controller=booking&action=step2');
    }

    public function step2(): void
    {
        session_start();

        $dt = $_SESSION['datetime'] ?? null;
        if (!$dt) {
            $this->redirect('?controller=booking&action=step1&error=Nejdřív vyber termín.');
        }

        $this->view->render('booking/step2', [
            'datetime' => $dt,
            'error' => $_GET['error'] ?? null,
        ]);
    }

    public function save(): void
    {
        session_start();

        $dt = $_SESSION['datetime'] ?? null;
        if (!$dt) {
            $this->redirect('?controller=booking&action=step1&error=Nejdřív vyber termín.');
        }

        $therapist = $_SESSION['booking_therapist'] ?? null;
        if (!$therapist) {
            $this->redirect('?controller=booking&action=step1&error=Nejdřív vyber masérku.');
        }

        $name  = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $note  = trim($_POST['note'] ?? '');

        if ($name === '' || ($email === '' && $phone === '')) {
            $this->redirect('?controller=booking&action=step2&error=Vyplň jméno a alespoň email nebo telefon.');
        }
        if ($email !== '' && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $this->redirect('?controller=booking&action=step2&error=Neplatný email.');
        }

        Reservation::create([
            'datetime'  => $dt,
            'therapist' => $therapist,
            'name'      => $name,
            'email'     => $email,
            'phone'     => $phone,
            'note'      => $note,
        ]);

        $this->redirect('?controller=booking&action=success');
    }

    public function success(): void
    {
        $this->view->render('booking/success');
    }


    public function show(): void
    {
        $id = (int)($_GET['id'] ?? 0);
        $reservation = Reservation::find($id);

        if (!$reservation) {
            http_response_code(404);
            echo "Rezervace nenalezena.";
            return;
        }

        $this->view->render('booking/show', [
            'reservation' => $reservation,
        ]);
    }

    public function edit(): void
    {
        $id = (int)($_GET['id'] ?? 0);
        $reservation = Reservation::find($id);

        if (!$reservation) {
            http_response_code(404);
            echo "Rezervace nenalezena.";
            return;
        }

        $this->view->render('booking/edit', [
            'reservation' => $reservation,
        ]);
    }

    public function update(): void
    {
        $id = (int)($_POST['id'] ?? 0);

        $data = [
            'datetime'  => trim($_POST['datetime'] ?? ''),
            'therapist' => trim($_POST['therapist'] ?? ''),
            'name'      => trim($_POST['name'] ?? ''),
            'email'     => trim($_POST['email'] ?? ''),
            'phone'     => trim($_POST['phone'] ?? ''),
            'note'      => trim($_POST['note'] ?? ''),
        ];

        Reservation::update($id, $data);

        $this->redirect('?controller=booking&action=index');
    }

    public function destroy(): void
    {
        $id = (int)($_POST['id'] ?? 0);
        Reservation::delete($id);

        $this->redirect('?controller=booking&action=index');
    }
}
