<?php
namespace App\Models;

use App\Core\Database;

class Reservation
{
    private static function db(): Database
    {
        /** @var Database $db */
        $db = $GLOBALS['db'] ?? null;

        if (!$db instanceof Database) {
            throw new \RuntimeException('Database is not initialized.');
        }

        return $db;
    }

    public static function getAll(): array
    {
        $db = self::db();

        $sql = "SELECT *
                FROM reservations
                ORDER BY datetime DESC, id DESC";

        return $db->pdo()->query($sql)->fetchAll(\PDO::FETCH_ASSOC);
    }

    public static function find(int $id): ?array
    {
        $db = self::db();

        $sql = "SELECT *
                FROM reservations
                WHERE id = :id
                LIMIT 1";

        $stmt = $db->pdo()->prepare($sql);
        $stmt->execute([':id' => $id]);

        $row = $stmt->fetch(\PDO::FETCH_ASSOC);
        return $row ?: null;
    }

    public static function create(array $data): int
{
    $db = self::db();

    $sql = "INSERT INTO reservations (datetime, therapist, name, email, phone, note)
            VALUES (:datetime, :therapist, :name, :email, :phone, :note)";

    $stmt = $db->pdo()->prepare($sql);

    $email = (isset($data['email']) && $data['email'] !== '') ? $data['email'] : null;
    $phone = (isset($data['phone']) && $data['phone'] !== '') ? $data['phone'] : null;
    $note  = (isset($data['note'])  && $data['note']  !== '') ? $data['note']  : null;

    $stmt->execute([
        ':datetime'  => $data['datetime'],
        ':therapist' => $data['therapist'],
        ':name'      => $data['name'],
        ':email'     => $email,
        ':phone'     => $phone,
        ':note'      => $note,
    ]);

    return (int)$db->pdo()->lastInsertId();
}

public static function update(int $id, array $data): void
{
    $db = self::db();

    $sql = "UPDATE reservations
            SET datetime = :datetime,
                therapist = :therapist,
                name = :name,
                email = :email,
                phone = :phone,
                note = :note
            WHERE id = :id";

    $stmt = $db->pdo()->prepare($sql);

    $email = (isset($data['email']) && $data['email'] !== '') ? $data['email'] : null;
    $phone = (isset($data['phone']) && $data['phone'] !== '') ? $data['phone'] : null;
    $note  = (isset($data['note'])  && $data['note']  !== '') ? $data['note']  : null;

    $stmt->execute([
        ':id'        => $id,
        ':datetime'  => $data['datetime'],
        ':therapist' => $data['therapist'],
        ':name'      => $data['name'],
        ':email'     => $email,
        ':phone'     => $phone,
        ':note'      => $note,
    ]);
}


    public static function delete(int $id): void
    {
        $db = self::db();

        $sql = "DELETE FROM reservations WHERE id = :id";
        $stmt = $db->pdo()->prepare($sql);
        $stmt->execute([':id' => $id]);
    }
}
