<?php
// app/Models/SupplierRepository.php
namespace App\Models;

use App\Core\Database;
use App\Models\Entities\SupplierEntity;

class SupplierRepository extends BaseRepository
{
    public function __construct(Database $db)
    {
        parent::__construct($db, 'suppliers', SupplierEntity::class);
    }

    /**
     * Vytvoří nového dodavatele z pole dat (typicky z formuláře).
     * Vrací id vloženého záznamu.
     */
    public function create(array $data): int
{
    // 1. Přidali jsme is_vip do seznamu sloupců i parametrů
    $stmt = $this->pdo->prepare("INSERT INTO suppliers (name, email, phone, is_vip) VALUES (:name, :email, :phone, :is_vip)");
    
    $stmt->execute([
        'name'   => $data['name'],
        'email'  => $data['email'] ?? null,
        'phone'  => $data['phone'] ?? null,
        // 2. Tohle políčko zpracuje checkbox: pokud je zaškrtnutý, pošle 1, jinak 0
        'is_vip' => isset($data['is_vip']) ? 1 : 0,
    ]);
    
    return (int)$this->pdo->lastInsertId();
}

    /**
     * Aktualizuje dodavatele podle id.
     */
    public function update(int $id, array $data): bool
{
    // Přidáno is_vip=:is_vip do SQL dotazu
    $stmt = $this->pdo->prepare("UPDATE suppliers SET name=:name, email=:email, phone=:phone, is_vip=:is_vip WHERE id=:id");
    return $stmt->execute([
        'name'   => $data['name'],
        'email'  => $data['email'] ?? null,
        'phone'  => $data['phone'] ?? null,
        'is_vip' => isset($data['is_vip']) ? 1 : 0, // Zpracování checkboxu
        'id'     => $id
    ]);
}
}