<?php
session_start();
require 'database.php';

// Kontrola přihlášení
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: access.php");
    exit;
}

// Načti značky a kategorie pro výběr
$brands = $pdo->query("SELECT id, Brand FROM brands")->fetchAll(PDO::FETCH_ASSOC);
$categories = $pdo->query("SELECT id, Category FROM categories")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <title>Přidat kolo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container my-5">
    <h2>Přidat nové kolo</h2>
    <form action="admin_save_bike.php" method="POST">
        <div class="mb-3">
            <label for="brand_id" class="form-label">Značka</label>
            <select name="brand_id" id="brand_id" class="form-control" required>
                <option value="">Vyber značku</option>
                <?php foreach ($brands as $brand): ?>
                    <option value="<?= $brand['id'] ?>"><?= htmlspecialchars($brand['Brand']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="category_id" class="form-label">Kategorie</label>
            <select name="category_id" id="category_id" class="form-control" required>
                <option value="">Vyber kategorii</option>
                <?php foreach ($categories as $category): ?>
                    <option value="<?= $category['id'] ?>"><?= htmlspecialchars($category['Category']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="model" class="form-label">Model</label>
            <input type="text" name="model" id="model" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="color" class="form-label">Barva</label>
            <input type="text" name="color" id="color" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="price" class="form-label">Cena (Kč)</label>
            <input type="number" name="price" id="price" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Popis</label>
            <textarea name="description" id="description" class="form-control" rows="4" required></textarea>
        </div>

        <div class="mb-3">
            <label for="image_main" class="form-label">Hlavní obrázek (název souboru např. bike01.jpg)</label>
            <input type="text" name="image_main" id="image_main" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="image_gallery" class="form-label">Galerie obrázků (odděleno čárkou, např. bike01.jpg,bike02.jpg)</label>
            <input type="text" name="image_gallery" id="image_gallery" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-success">Uložit</button>
        <a href="admin_dashboard.php" class="btn btn-secondary">Zrušit</a>
    </form>
</div>
</body>
</html>
