<?php
session_start();
require 'database.php';

// Kontrola přihlášení
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: access.php");
    exit;
}

// Načtení všech kol
$sql = "SELECT bikes.id, bikes.model, bikes.price, brands.Brand AS brand_name
        FROM bikes
        JOIN brands ON bikes.brand_id = brands.id";
$stmt = $pdo->query($sql);
$bikes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <title>Admin - Katalog kol</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container my-5">
    <h2 class="mb-4">Administrace katalogu kol</h2>

    <div class="mb-3 text-end">
        <a href="logout.php" class="btn btn-outline-danger">Odhlásit se</a>
        <a href="admin_add_bike.php" class="btn btn-primary">+ Přidat nové kolo</a>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Značka</th>
                <th>Model</th>
                <th>Cena</th>
                <th>Akce</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($bikes as $bike): ?>
            <tr>
                <td><?= $bike['id'] ?></td>
                <td><?= htmlspecialchars($bike['brand_name']) ?></td>
                <td><?= htmlspecialchars($bike['model']) ?></td>
                <td><?= number_format($bike['price'], 0, ',', ' ') ?> Kč</td>
                <td>
                    <a href="admin_edit_bike.php?id=<?= $bike['id'] ?>" class="btn btn-sm btn-warning">Upravit</a>
                    <a href="admin_delete_bike.php?id=<?= $bike['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Opravdu chceš smazat toto kolo?');">Smazat</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
