<?php
require 'database.php';

$bikeId = isset($_GET['id']) ? (int) $_GET['id'] : 0;

$stmt = $pdo->prepare("SELECT bikes.*, brands.Brand AS brand_name, categories.Category AS category_name 
        FROM bikes 
        JOIN brands ON bikes.brand_id = brands.id 
        JOIN categories ON bikes.category_id = categories.id 
        WHERE bikes.id = :id");
$stmt->execute(['id' => $bikeId]);
$bike = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$bike) {
    echo "Kolo nebylo nalezeno.";
    exit;
}

$imageGallery = explode(',', $bike['image_gallery']);
?>
<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($bike['brand_name']) ?> <?= htmlspecialchars($bike['model']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --dirt-bg: #23201c;
            --dirt-bg-light: #3a3732;
            --dirt-bg-dark: #181714;
            --dirt-gray: #6e6a65;
            --dirt-gray-light: #a9a29a;
            --dirt-accent: #bfa97a;
            --dirt-accent-dark: #9e8758;
            --dirt-white: #eae6df;
        }
        body {
            background: var(--dirt-bg) url('img/neutral_background.png') no-repeat center center fixed;
            background-size: cover;
            color: var(--dirt-white);
            font-family: 'Segoe UI', 'Roboto', Arial, sans-serif;
        }
        .container {
            background: rgba(35, 32, 28, 0.93);
            border-radius: 18px;
            box-shadow: 0 8px 32px rgba(0,0,0,0.28);
            margin-top: 36px;
            margin-bottom: 36px;
            padding: 32px 28px;
        }
        .btn-secondary {
            background: var(--dirt-bg-light);
            border: none;
            color: var(--dirt-accent);
            font-weight: 600;
            transition: background 0.2s, color 0.2s;
        }
        .btn-secondary:hover, .btn-secondary:focus {
            background: var(--dirt-accent-dark);
            color: var(--dirt-bg-dark);
        }
        .main-image, .carousel-inner img {
            background: var(--dirt-bg-dark);
            max-width: 100%;
            max-height: 420px;
            object-fit: contain;
            border-radius: 14px;
            cursor: pointer;
            box-shadow: 0 6px 32px rgba(0,0,0,0.23);
            border: 2px solid var(--dirt-gray);
            transition: box-shadow 0.2s;
        }
        .main-image:hover, .carousel-inner img:hover {
            box-shadow: 0 10px 40px rgba(191,169,122,0.14);
            border-color: var(--dirt-accent);
        }
        .carousel-control-prev-icon,
        .carousel-control-next-icon {
            filter: invert(70%) sepia(18%) saturate(300%) hue-rotate(20deg) brightness(90%);
        }
        .bike-info h2 {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 18px;
            color: var(--dirt-accent);
            letter-spacing: 0.03em;
        }
        .bike-info p {
            font-size: 1.17rem;
            line-height: 1.7;
            color: var(--dirt-gray-light);
        }
        .bike-info strong {
            color: var(--dirt-accent-dark);
        }
        .modal-content {
            background: rgba(35, 32, 28, 0.98);
            border-radius: 14px;
            box-shadow: 0 10px 40px rgba(191,169,122,0.14);
            border: 2px solid var(--dirt-accent-dark);
        }
        .modal-body img {
            max-height: 80vh;
            border-radius: 12px;
            background: var(--dirt-bg-dark);
        }
        .btn-nav {
            z-index: 2;
            background: var(--dirt-bg-light);
            border-radius: 50%;
            width: 44px;
            height: 44px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.19);
            color: var(--dirt-accent);
            font-size: 1.5rem;
            border: 2px solid var(--dirt-accent-dark);
            transition: background 0.2s, color 0.2s;
        }
        .btn-nav:hover {
            background: var(--dirt-accent-dark);
            color: var(--dirt-bg-dark);
        }
        @media (max-width: 991px) {
            .container { padding: 18px 8px; }
            .main-image, .carousel-inner img { max-height: 260px; }
            .bike-info h2 { font-size: 1.5rem; }
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <a href="access.php" class="btn btn-secondary mb-4"><i class="bi bi-arrow-left"></i> Zpět na katalog</a>

        <div class="row g-5 align-items-start">
            <div class="col-lg-6 text-center">
                <div id="bikeCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <?php foreach ($imageGallery as $index => $image): ?>
                            <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
                                <img src="img/<?= htmlspecialchars($image) ?>" class="d-block w-100 main-image" alt="Obrázek kola" loading="lazy" data-bs-toggle="modal" data-bs-target="#imageModal">
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <button class="carousel-control-prev" type="button" data-bs-target="#bikeCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Previous</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#bikeCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Next</span>
                    </button>
                </div>
            </div>
            <div class="col-lg-6 bike-info">
                <h2><i class="bi bi-bicycle"></i> <?= htmlspecialchars($bike['brand_name']) ?> <?= htmlspecialchars($bike['model']) ?></h2>
                <p><i class="bi bi-tags"></i> <strong>Kategorie:</strong> <?= htmlspecialchars($bike['category_name']) ?></p>
                <p><i class="bi bi-palette"></i> <strong>Barva:</strong> <?= htmlspecialchars($bike['color']) ?></p>
                <p><i class="bi bi-currency-exchange"></i> <strong>Cena:</strong> <?= number_format($bike['price'], 0, ',', ' ') ?> Kč</p>
                <p><i class="bi bi-info-circle"></i> <strong>Popis:</strong><br><?= nl2br(htmlspecialchars($bike['description'])) ?></p>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
          <div class="modal-body text-center position-relative">
            <button id="prevImage" class="btn btn-nav position-absolute top-50 start-0 translate-middle-y">&larr;</button>
            <img id="modalImage" src="" class="img-fluid rounded" alt="Zvětšený obrázek">
            <button id="nextImage" class="btn btn-nav position-absolute top-50 end-0 translate-middle-y">&rarr;</button>
          </div>
        </div>
      </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const gallery = <?= json_encode(array_map('htmlspecialchars', $imageGallery)) ?>;
        let currentIndex = 0;

        const modalImage = document.getElementById('modalImage');
        const prevBtn = document.getElementById('prevImage');
        const nextBtn = document.getElementById('nextImage');

        document.querySelectorAll('.carousel-item img').forEach((img, index) => {
            img.addEventListener('click', () => {
                currentIndex = index;
                modalImage.src = img.src;
                const modal = new bootstrap.Modal(document.getElementById('imageModal'));
                modal.show();
            });
        });

        prevBtn.addEventListener('click', () => {
            currentIndex = (currentIndex - 1 + gallery.length) % gallery.length;
            modalImage.src = 'img/' + gallery[currentIndex];
        });

        nextBtn.addEventListener('click', () => {
            currentIndex = (currentIndex + 1) % gallery.length;
            modalImage.src = 'img/' + gallery[currentIndex];
        });
    </script>
</body>
</html>
