<?php
namespace App\Models;
use App\Core\Database;
use App\Models\Entities\CustomerEntity;

class CustomerRepository extends BaseRepository {
    public function __construct(Database $db) {
        parent::__construct($db, 'customers', CustomerEntity::class);
    }

    public function create(array $data): int {
        $stmt = $this->pdo->prepare("INSERT INTO customers (first_name, last_name, email, phone, address) VALUES (:first_name, :last_name, :email, :phone, :address)");
        $stmt->execute([
            'first_name' => $data['first_name'],
            'last_name'  => $data['last_name'],
            'email'      => $data['email'] ?: null,
            'phone'      => $data['phone'] ?: null,
            'address'    => $data['address'] ?: null,
        ]);
        return (int)$this->pdo->lastInsertId();
    }

    public function update(int $id, array $data): bool {
        $stmt = $this->pdo->prepare("UPDATE customers SET first_name = :first_name, last_name = :last_name, email = :email, phone = :phone, address = :address WHERE id = :id");
        return $stmt->execute([
            'first_name' => $data['first_name'],
            'last_name'  => $data['last_name'],
            'email'      => $data['email'] ?: null,
            'phone'      => $data['phone'] ?: null,
            'address'    => $data['address'] ?: null,
            'id'         => $id
        ]);
    }
}